# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_d:
        return "D"
    
    if always_c:
        if len(my_history) % 4 == 0:
            return "D"
        else:
            return "C"
    
    if len(my_history) >= 8 and any(move == "D" for move in opp_history):
        return "D"
    
    if opp_history[-1] == "D":
        return "D"
    else:
        if len(my_history) % 4 == 0:
            return "D"
        else:
            return "C"